import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { Toaster } from "@/components/ui/toaster";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "GameShop - Game Premium Murah",
  description: "Akses game favorit Anda dengan harga terbaik. Delta Force, PUBG Mobile, Mobile Legend.",
  keywords: ["GameShop", "game premium", "Delta Force", "PUBG Mobile", "Mobile Legend", "game murah"],
  authors: [{ name: "GameShop Team" }],
  openGraph: {
    title: "GameShop - Game Premium Murah",
    description: "Akses game favorit Anda dengan harga terbaik",
    url: "https://gameshop.com",
    siteName: "GameShop",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "GameShop - Game Premium Murah",
    description: "Akses game favorit Anda dengan harga terbaik",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased bg-background text-foreground`}
      >
        {children}
        <Toaster />
      </body>
    </html>
  );
}
